/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.symfony.liveTemplates;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateOptionalProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.symfony.SymfonyBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.psi.PhpGroupUseElement;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpAttributesFQNsIndex;
import com.jetbrains.php.refactoring.PhpAliasImporter;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J(\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0011H\u0002J(\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0011H\u0002\u00a8\u0006\u001b"}, d2={"Lcom/intellij/symfony/liveTemplates/SymfonyImportTemplateOptionalProcessor;", "Lcom/intellij/codeInsight/template/impl/TemplateOptionalProcessor;", "<init>", "()V", "processText", "", "project", "Lcom/intellij/openapi/project/Project;", "template", "Lcom/intellij/codeInsight/template/Template;", "document", "Lcom/intellij/openapi/editor/Document;", "templateRange", "Lcom/intellij/openapi/editor/RangeMarker;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getOptionName", "", "isEnabled", "", "importReference", "element", "Lcom/intellij/psi/PsiElement;", "templateText", "importClassReference", "attributeName", "Companion", "intellij.symfony"})
@SourceDebugExtension(value={"SMAP\nSymfonyImportTemplateOptionalProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SymfonyImportTemplateOptionalProcessor.kt\ncom/intellij/symfony/liveTemplates/SymfonyImportTemplateOptionalProcessor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1321#2,2:65\n295#3,2:67\n*S KotlinDebug\n*F\n+ 1 SymfonyImportTemplateOptionalProcessor.kt\ncom/intellij/symfony/liveTemplates/SymfonyImportTemplateOptionalProcessor\n*L\n43#1:65,2\n50#1:67,2\n*E\n"})
public final class SymfonyImportTemplateOptionalProcessor
implements TemplateOptionalProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<String, String> aliases;
    @NotNull
    private static final Set<String> complicatedTemplates;

    public void processText(@Nullable Project project, @Nullable Template template, @Nullable Document document, @Nullable RangeMarker templateRange, @Nullable Editor editor) {
        PsiElement element;
        if (template == null || project == null || editor == null || document == null || !this.isEnabled(template)) {
            return;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        PsiElement psiElement = element = psiFile != null ? psiFile.findElementAt(editor.getCaretModel().getOffset()) : null;
        if (element == null) {
            return;
        }
        String string = template.getTemplateText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTemplateText(...)");
        this.importReference(project, element, document, string);
    }

    @NotNull
    public String getOptionName() {
        return SymfonyBundle.INSTANCE.message("template.add.imports", new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isEnabled(@Nullable Template template) {
        if (template == null) return false;
        TemplateImpl templateImpl = template instanceof TemplateImpl ? (TemplateImpl)template : null;
        if (!Intrinsics.areEqual((Object)(templateImpl != null ? templateImpl.getGroupName() : null), (Object)"Symfony")) return false;
        if (complicatedTemplates.contains(((TemplateImpl)template).getKey())) return false;
        return true;
    }

    private final void importReference(Project project, PsiElement element, Document document, String templateText) {
        Sequence $this$forEach$iv = Regex.findAll$default((Regex)new Regex("#\\[([^\\(\\[\\]]*).|\\n*\\]"), (CharSequence)templateText, (int)0, (int)2, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MatchResult it = (MatchResult)element$iv;
            boolean bl = false;
            String attributeName = (String)it.getDestructured().getMatch().getGroupValues().get(1);
            this.importClassReference(project, element, document, StringsKt.substringAfterLast$default((String)attributeName, (String)"\\", null, (int)2, null));
        }
    }

    private final void importClassReference(Project project, PsiElement element, Document document, String attributeName) {
        String string;
        Object v1;
        block6: {
            Collection collection = PhpIndex.getInstance((Project)project).getClassesByName(attributeName);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getClassesByName(...)");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PhpClass it = (PhpClass)element$iv;
                boolean bl = false;
                if (!PhpAttributesFQNsIndex.hasRootAttribute(it)) continue;
                v1 = element$iv;
                break block6;
            }
            v1 = null;
        }
        PhpClass clazz = v1;
        if (clazz == null) {
            return;
        }
        PhpPsiElement scopeForUseOperator = PhpCodeInsightUtil.findScopeForUseOperator(element);
        if (scopeForUseOperator == null) {
            return;
        }
        String string2 = clazz.getFQN();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFQN(...)");
        String alias = aliases.get(StringsKt.substringBeforeLast$default((String)string2, (String)"\\", null, (int)2, null));
        if (alias == null) {
            string = clazz.getFQN();
        } else {
            String string3 = clazz.getFQN();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getFQN(...)");
            string = StringsKt.substringBeforeLast$default((String)string3, (String)"\\", null, (int)2, null);
        }
        String string4 = string;
        Intrinsics.checkNotNull((Object)string4);
        String fqn = string4;
        if (PhpCodeInsightUtil.findImportedName(scopeForUseOperator, fqn, PhpGroupUseElement.PhpUseKeyword.CLASS) != null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        PhpAliasImporter.insertUseStatementWithKeyword(null, fqn, alias, scopeForUseOperator);
    }

    static {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"\\Doctrine\\ORM\\Mapping", (Object)"ORM"), TuplesKt.to((Object)"\\Symfony\\Component\\Validator\\Constraints", (Object)"Assert")};
        aliases = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new String[]{"command", "entity", "controller"};
        complicatedTemplates = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/symfony/liveTemplates/SymfonyImportTemplateOptionalProcessor$Companion;", "", "<init>", "()V", "aliases", "", "", "getAliases", "()Ljava/util/Map;", "complicatedTemplates", "", "getComplicatedTemplates", "()Ljava/util/Set;", "intellij.symfony"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, String> getAliases() {
            return aliases;
        }

        @NotNull
        public final Set<String> getComplicatedTemplates() {
            return complicatedTemplates;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

