/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.joomla.database;

import com.intellij.database.Dbms;
import com.intellij.database.autoconfig.DataSourceConfigUtil;
import com.intellij.database.autoconfig.DataSourceConfiguration;
import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.database.util.DbUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.joomla.init.JoomlaContentConfigurationManager;
import com.jetbrains.php.joomla.settings.JoomlaDataService;
import com.jetbrains.php.lang.psi.PhpFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpDataSourceDetector
extends DataSourceDetector {
    public boolean isRelevantFile(@NotNull PsiFile file) {
        if (file == null) {
            PhpDataSourceDetector.$$$reportNull$$$0(0);
        }
        if (!file.getName().equals("configuration.php")) {
            return false;
        }
        return file.equals(JoomlaContentConfigurationManager.getInstance().getConfigurationFile(file.getProject()));
    }

    public void collectDataSources(final @NotNull Project project, @NotNull DataSourceDetector.Builder builder) {
        Dbms dbms;
        if (project == null) {
            PhpDataSourceDetector.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            PhpDataSourceDetector.$$$reportNull$$$0(2);
        }
        if (DumbService.isDumb((Project)project)) {
            return;
        }
        JoomlaContentConfigurationManager instance = JoomlaContentConfigurationManager.getInstance();
        PhpFile configurationFile = instance.getConfigurationFile(project);
        JoomlaDataService joomlaDataService = JoomlaDataService.getInstance(project);
        if (!joomlaDataService.isEnabled() || configurationFile == null) {
            return;
        }
        final String host = instance.getProperty(project, "host");
        final String user = instance.getProperty(project, "user");
        final String password = instance.getProperty(project, "password");
        final String dbName = instance.getProperty(project, "db");
        String dbType = instance.getProperty(project, "dbtype");
        Dbms dbms2 = dbms = "sqlsrv".equals(dbType) ? Dbms.MSSQL : Dbms.fromString((String)dbType);
        if (dbms == Dbms.UNKNOWN) {
            return;
        }
        DataSourceConfiguration config = new DataSourceConfiguration(){

            @Nullable
            public String getDatabase() {
                return dbName;
            }

            @Nullable
            public String getHost() {
                return host;
            }

            @Nullable
            public String getUserName() {
                return user;
            }

            @Nullable
            public String getPassword() {
                return password;
            }

            @Nullable
            public VirtualFile getApplicationRoot() {
                return project.getBaseDir();
            }
        };
        String datasourceName = "joomla.datasource";
        datasourceName = DbUtil.generateUniqueDataSourceName((Project)project, (String)datasourceName);
        DataSourceConfigUtil.buildDataSource((Dbms)dbms, (String)datasourceName, (String)"joomla.datasource", (PsiElement)configurationFile, (DataSourceConfiguration)config, (DataSourceDetector.Builder)builder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/joomla/database/PhpDataSourceDetector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isRelevantFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "collectDataSources";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

