/*
 * Decompiled with CFR 0.152.
 */
package com.pestphp.pest.annotator;

import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.FileBasedIndex;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.annotator.PhpDeleteElementQuickFix;
import com.jetbrains.php.lang.inspections.controlFlow.PhpNavigateToElementQuickFix;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.impl.MethodReferenceImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.pestphp.pest.PestBundle;
import com.pestphp.pest.PestFunctionsUtilKt;
import com.pestphp.pest.PestNamingUtilKt;
import com.pestphp.pest.features.customExpectations.CustomExpectationIndexKt;
import com.pestphp.pest.features.customExpectations.ExpectationUtilKt;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J\u001e\u0010\u0015\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00160\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/pestphp/pest/annotator/PestAnnotatorVisitor;", "Lcom/jetbrains/php/lang/psi/visitors/PhpElementVisitor;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "<init>", "(Lcom/intellij/lang/annotation/AnnotationHolder;)V", "visitPhpMethodReference", "", "reference", "Lcom/jetbrains/php/lang/psi/elements/MethodReference;", "checkDuplicateCustomExpectations", "getNavigateToCustomExpectationFix", "Lcom/intellij/modcommand/ModCommandAction;", "duplicates", "", "duplicate", "visitPhpFile", "phpFile", "Lcom/jetbrains/php/lang/psi/PhpFile;", "checkDuplicateTestNames", "file", "getNavigateToTestNameFix", "Lcom/jetbrains/php/lang/psi/elements/FunctionReference;", "duplicateIndex", "", "intellij.pest"})
@SourceDebugExtension(value={"SMAP\nPestAnnotatorVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PestAnnotatorVisitor.kt\ncom/pestphp/pest/annotator/PestAnnotatorVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,103:1\n1869#2,2:104\n1491#2:106\n1516#2,3:107\n1519#2,3:117\n1878#2,3:135\n1869#2,2:139\n382#3,7:110\n488#3,7:120\n536#3:127\n521#3,6:128\n216#4:134\n217#4:138\n*S KotlinDebug\n*F\n+ 1 PestAnnotatorVisitor.kt\ncom/pestphp/pest/annotator/PestAnnotatorVisitor\n*L\n57#1:104,2\n83#1:106\n83#1:107,3\n83#1:117,3\n87#1:135,3\n38#1:139,2\n83#1:110,7\n84#1:120,7\n85#1:127\n85#1:128,6\n86#1:134\n86#1:138\n*E\n"})
public final class PestAnnotatorVisitor
extends PhpElementVisitor {
    @NotNull
    private final AnnotationHolder holder;

    public PestAnnotatorVisitor(@NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
    }

    public void visitPhpMethodReference(@NotNull MethodReference reference) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        this.checkDuplicateCustomExpectations(reference);
    }

    private final void checkDuplicateCustomExpectations(MethodReference reference) {
        if (!(reference instanceof MethodReferenceImpl)) {
            return;
        }
        String string = ExpectationUtilKt.getExtendName(reference);
        if (string == null) {
            return;
        }
        String extendName = string;
        List duplicates = new ArrayList();
        FileBasedIndex.getInstance().processValues(CustomExpectationIndexKt.getKEY(), (Object)extendName, null, (arg_0, arg_1) -> PestAnnotatorVisitor.checkDuplicateCustomExpectations$lambda$3((arg_0, arg_1) -> PestAnnotatorVisitor.checkDuplicateCustomExpectations$lambda$2(reference, duplicates, arg_0, arg_1), arg_0, arg_1), GlobalSearchScope.allScope((Project)((MethodReferenceImpl)reference).getProject()));
        if (duplicates.size() > 1) {
            Object[] objectArray = new ModCommandAction[2];
            Object[] objectArray2 = new Object[]{extendName};
            objectArray[0] = new PhpDeleteElementQuickFix(((MethodReferenceImpl)reference).getParent(), PestBundle.message("QUICK_FIX_DELETE_CUSTOM_EXPECTATION", objectArray2));
            objectArray[1] = this.getNavigateToCustomExpectationFix(duplicates, reference);
            List fixes = CollectionsKt.listOfNotNull((Object[])objectArray);
            AnnotationBuilder annotationBuilder = this.holder.newAnnotation(HighlightSeverity.WARNING, PestBundle.message("INSPECTION_DUPLICATE_CUSTOM_EXPECTATION", new Object[0])).range((PsiElement)reference);
            Intrinsics.checkNotNullExpressionValue((Object)annotationBuilder, (String)"range(...)");
            AnnotationBuilder builder = annotationBuilder;
            Iterable $this$forEach$iv = fixes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ModCommandAction fix = (ModCommandAction)element$iv;
                boolean bl = false;
                builder.withFix(fix.asIntention());
            }
            builder.create();
        }
    }

    private final ModCommandAction getNavigateToCustomExpectationFix(List<? extends MethodReference> duplicates, MethodReference duplicate) {
        int duplicateIndex = duplicates.indexOf(duplicate);
        if (duplicateIndex == -1) {
            return null;
        }
        MethodReference nextElement = duplicates.get((duplicateIndex + 1) % duplicates.size());
        return (ModCommandAction)new PhpNavigateToElementQuickFix((PsiElement)nextElement, PestBundle.message("INTENTION_NAVIGATE_TO_DUPLICATE_CUSTOM_EXPECTATION", new Object[0]));
    }

    public void visitPhpFile(@NotNull PhpFile phpFile) {
        Intrinsics.checkNotNullParameter((Object)phpFile, (String)"phpFile");
        this.checkDuplicateTestNames(phpFile);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkDuplicateTestNames(PhpFile file) {
        void $this$filterTo$iv$iv;
        List answer$iv$iv$iv;
        boolean bl;
        Object it;
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = PestFunctionsUtilKt.getPestTests((PsiFile)file, true);
        boolean $i$f$groupBy = false;
        Object object = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean bl2 = false;
        for (Object t : $this$groupByTo$iv$iv) {
            Object object2;
            it = (FunctionReference)t;
            bl = false;
            String key$iv$iv = PestNamingUtilKt.getPestTestName((PsiElement)it);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl22 = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(t);
        }
        Map $this$filterKeys$iv = destination$iv$iv;
        boolean $i$f$filterKeys = false;
        Map result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterKeys$iv.entrySet()) {
            String it2 = (String)entry.getKey();
            boolean bl3 = false;
            if (!(it2 != null)) continue;
            ((HashMap)result$iv).put(entry.getKey(), entry.getValue());
        }
        Map $this$filter$iv = result$iv;
        boolean $i$f$filter = false;
        result$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean entry = false;
        for (Map.Entry entry2 : $this$filterTo$iv$iv.entrySet()) {
            it = entry2;
            bl = false;
            if (!(((Collection)it.getValue()).size() > 1)) continue;
            destination$iv$iv.put(entry2.getKey(), entry2.getValue());
        }
        Object $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry3 = element$iv = (Map.Entry)object.next();
            boolean bl4 = false;
            List list = (List)entry3.getValue();
            Iterable $this$forEachIndexed$iv = list;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                String testName;
                void test;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                answer$iv$iv$iv = (FunctionReference)item$iv;
                int index = n;
                boolean bl3 = false;
                if (PestNamingUtilKt.getPestTestName((PsiElement)test) == null) continue;
                CommonIntentionAction[] commonIntentionActionArray = new CommonIntentionAction[2];
                Object[] objectArray = new Object[]{testName};
                commonIntentionActionArray[0] = new PhpDeleteElementQuickFix(test.getParent(), PestBundle.message("QUICK_FIX_DELETE_TEST", objectArray));
                commonIntentionActionArray[1] = this.getNavigateToTestNameFix(list, index);
                PhpAnnotatorVisitor.createErrorAnnotation((AnnotationHolder)this.holder, (PsiElement)((PsiElement)test), (String)PestBundle.message("INSPECTION_DUPLICATE_TEST_NAME", new Object[0]), (CommonIntentionAction[])commonIntentionActionArray);
            }
        }
    }

    private final ModCommandAction getNavigateToTestNameFix(List<? extends FunctionReference> duplicates, int duplicateIndex) {
        FunctionReference nextElement = duplicates.get((duplicateIndex + 1) % duplicates.size());
        return (ModCommandAction)new PhpNavigateToElementQuickFix((PsiElement)nextElement, PestBundle.message("INTENTION_NAVIGATE_TO_DUPLICATE_TEST_NAME", new Object[0]));
    }

    private static final boolean checkDuplicateCustomExpectations$lambda$2(MethodReference $reference, List $duplicates, VirtualFile file, IntList offsets) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            PsiFile psiFile = ((MethodReferenceImpl)$reference).getManager().findFile(file);
            if (psiFile == null) break block1;
            PsiFile psiFile2 = psiFile;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)offsets);
            Iterable $this$forEach$iv = (Iterable)offsets;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Integer offset = (Integer)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)offset);
                PsiElement expectation = psiFile2.findElementAt(offset.intValue());
                MethodReference methodDescriptor = (MethodReference)PhpPsiUtil.getParentOfClass((PsiElement)expectation, MethodReference.class);
                if (methodDescriptor == null) continue;
                $duplicates.add(methodDescriptor);
            }
        }
        return true;
    }

    private static final boolean checkDuplicateCustomExpectations$lambda$3(Function2 $tmp0, VirtualFile p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        return (Boolean)$tmp0.invoke((Object)p0, p1);
    }
}

